#version 460

uniform samplerCube tex_cm;
uniform float eta;
uniform float eta_disp;

in vec3 n;
in vec3 incident;

out vec4 color;

void main() {

    vec3 nn = normalize(n);
    vec3 i = normalize(incident);

    vec3 refl = reflect(i, nn);
    vec4 c_refl = texture(tex_cm, refl);

    vec3 refr_r = refract(i, nn, eta);
    float c_refr_r = texture(tex_cm, refr_r).r;
    
    vec3 refr_g = refract(i, nn, eta + eta_disp);
    float c_refr_g = texture(tex_cm, refr_g).g;
    
    vec3 refr_b = refract(i, nn, eta + 2 * eta_disp);
    float c_refr_b = texture(tex_cm, refr_b).b;

    float dot_IN = dot(i, nn);
    float  R = eta * eta * (1.0 - dot_IN * dot_IN);

    color = mix(vec4(c_refr_r, c_refr_g, c_refr_b,1), c_refl, R);
}
